### 1. Introduction to VLANs

- **Benefits:**
    - Easy network segmentation.
    - Improved security.
    - Increased flexibility.
- **Potential Problems:**
    - Incorrect configuration can lead to security vulnerabilities.
    - VLAN hopping attacks (basic and double-tagging) are a major concern.
    - Requires appropriate mitigation techniques.

### 2. VLAN Configuration Basics

- **Access Interfaces:**
    - Connect to end devices.
    - Assigned to a single VLAN.
- **Trunk Ports:**
    - Connect switches to each other.
    - Carry traffic from multiple VLANs over a single physical link.
    - Point-to-point links.
- **Dynamic Trunking Protocol (DTP):**
    - Used to negotiate access or trunk mode between interconnecting switches.
    - Enabled by default on Cisco switches.

### 3. Trunking Protocols

- **Purpose:** Allow multiple VLANs to be shared between switches using minimal physical connections.
- **Protocols:**
    - **Inter-Switch Link (ISL):** Cisco proprietary protocol (less common in modern networks).
    - **IEEE 802.1Q:**
        - Industry standard, widely used.
        - Introduces a tag into the Ethernet header to specify the VLAN.
        - Tag inserted on egress from a trunk port, stripped on ingress to an access port.
        - **Native VLAN:**
            - A trunk port is assigned a native VLAN (VLAN 1 by default).
            - Traffic associated with the native VLAN is sent **untagged**.
            - Untagged frames arriving on a trunk port are assigned to the native VLAN.
            - Requires the same native VLAN configuration on both ends of a trunk link.

### 4. Inter-VLAN Communication

- VLANs perform network partitioning and traffic separation at Layer 2 (broadcast domains).
- Communication between different VLANs (broadcast domains) requires a Layer 3 device (e.g., a router).

### 5. VLAN Hopping Attacks

- **General Concept:** Allows traffic from one VLAN to be accessed by another VLAN without crossing a router, potentially enabling data sniffing and information extraction.
- **Basic VLAN Hopping Attack:**
    - **Mechanism:** Exploits DTP being enabled by default.
    - **Process:** An attacker configures their system to use DTP to negotiate a trunk link with the switch.
    - **Result:** The attacker gains access to all VLANs trunked on the switch and can send/receive traffic on them.
- **Double-Tagging (Double-Encapsulated) VLAN Hopping Attack:**
    - **Mechanism:** Exploits how some switches handle 802.1Q decapsulation (only one level).
    - **Process:**
        1. Attacker sends a double-tagged 802.1Q frame.
        2. **Outer Tag:** Attacker's VLAN (must be the same as the trunk port's native VLAN).
        3. **Inner Tag:** Victim VLAN.
        4. Switch processes the outer tag, strips it (because it's the native VLAN), and forwards the frame out the trunk.
        5. The inner tag (victim VLAN) remains.
        6. The second switch (or destination device) sees only the inner tag and forwards the frame to the victim VLAN.
    - **Characteristics:**
        - Unidirectional.
        - Works even if DTP is disabled on the attacker's access port.
        - Requires the attacker and trunk port to have the same native VLAN.

### 6. Mitigation Techniques Against VLAN Hopping

- **General Principles:**
    
    - Explicitly assign `access` or `trunk` mode to all interfaces.
    - Disable DTP protocol on interfaces.
    - Explicitly define a dedicated native VLAN on trunk links.
- **Mitigation for Basic VLAN Hopping:**
    
    - **Explicitly Configure Port Mode:** Configure switch ports as either `switchport mode access` or `switchport mode trunk`.
    - **Disable DTP:** Use `switchport nonegotiate` on all ports (access and trunk) to prevent DTP negotiation. This is crucial as DTP default modes (dynamic auto/desirable) allow trunk negotiation.
- **Mitigation for Double-Tagging VLAN Hopping:**
    
    - **Dedicated Native VLAN:**
        - Create a unique VLAN to be used _only_ as the native VLAN on all trunk ports.
        - **Do not use this VLAN for any access ports or end devices.**
        - This ensures that no legitimate traffic or attacker's device resides on the native VLAN, preventing the inner tag from being exposed.
- **Configuration Example (Illustrative):**
    
    - `vlan 999` (create dedicated native VLAN)
    - `name native-trunkonly`
    - `interface FastEthernet 0/1` (trunk port)
        - `switchport mode trunk`
        - `switchport nonegotiate` (disable DTP)
        - `switchport trunk native vlan 999`
    - `interface range FastEthernet 0/22-24` (access ports)
        - `switchport mode access`
        - `switchport nonegotiate` (recommended, but optional for access ports)